<!DOCTYPE html>
<html lang="en">
    <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- The above 3 meta tags *must* come first in the head; any other head content must come *after* these tags -->
    <title>历史编译记录</title>

    <!-- Bootstrap -->
    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">

    <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
      <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
      <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
  </head>
  <body>
    <nav class="navbar navbar-inverse navbar-fixed-top">
      <div class="container">
        <div class="navbar-header">
          <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar" aria-expanded="false" aria-controls="navbar">
            <span class="sr-only">Toggle navigation</span>
            <span class="icon-bar"></span>
            <span class="icon-bar"></span>
            <span class="icon-bar"></span>
          </button>
          <a class="navbar-brand" href="#">自动编译系统</a>
        </div>
        <div id="navbar" class="collapse navbar-collapse">
          <ul class="nav navbar-nav">
            <li><a href="index.php">选择版本</a></li>
            <li><a href="compile_log.php">编译日志</a></li>
            <li class="active"><a href="#">历史记录</a></li>
          </ul>
        </div><!--/.nav-collapse -->
      </div>
    </nav>

    <div class="container">

      <div class="starter-template">
        
            <div class="panel panel-default">
              
              <div class="panel-body">
                    <table class="table table-striped table-hover" style="table-layout:fixed">
                      <thead>
                        <tr>
                          <th width="5%">#</th>
                          <th width="20%">编译版本</th>
                          <th width="15%">编译时间</th>
                          <th width="15%">编译人</th>
                          <th>编译说明</th>
                        </tr>
                      </thead>

                      <tbody style="text-align:left">
                        <?php
                          $logfile = "compile.history";  

                          $file = file($logfile);
                          $file = array_reverse($file);
                          $count = 1;
                          foreach($file as $f){
                              $row = json_decode($f, true);
                              ?>
                              <tr>
                                    <td><?php echo $count ?></td>
                                    <td>
                                    <?php 
                                      echo $row["version"];

                                      if ($row["mode"] == 1) {
                                        ?>
                                        <span class="label label-success">发布版</span>
                                        <?php
                                      }  

                                    ?></td>
                                    <td><?php echo $row["starttime"] ?></td>
                                    <td><?php echo $row["email"] ?></td>
                                    <td style="overflow:hidden;white-space:nowrap;text-overflow:ellipsis;" title='<?php echo $row["remark"] ?>'><?php echo $row["remark"] ?></td>
                                  </tr>
                              <?php
                              $count++;
                          }
                        ?>


                      </tbody>

                    </table>
              </div>

            </div>

      </div>

    </div><!-- /.container -->


    <!-- jQuery (necessary for Bootstrap's JavaScript plugins) -->
    <script src="js/jquery.min.js"></script>
    <!-- Include all compiled plugins (below), or include individual files as needed -->
    <script src="js/bootstrap.min.js"></script>
  </body>

</html>