    $(function () {
        var $lastWidget = null;

        $('.list-group.checked-list-box .list-group-item').each(function () {
            // Settings
            var $widget = $(this),
                $checkbox = $('<input type="checkbox" class="hidden" />'),
                color = ($widget.data('color') ? $widget.data('color') : "primary"),
                style = ($widget.data('style') == "button" ? "btn-" : "list-group-item-"),
                settings = {
                    on: {
                        icon: 'glyphicon glyphicon-check'
                    },
                    off: {
                        icon: 'glyphicon glyphicon-unchecked'
                    }
                };
                
            $widget.css('cursor', 'pointer');
            $widget.append($checkbox);
    
            // Event Handlers
            $widget.on('click', function () {
                $checkbox.prop('checked', !$checkbox.is(':checked'));
                $checkbox.triggerHandler('change');
                updateDisplay();
            });
            $checkbox.on('change', function () {
                updateDisplay();
            });
              
            // Actions
            function updateDisplay() {
                var isChecked = $checkbox.is(':checked');

                if (isChecked) {
                    $widget.next().collapse("show");

                    if ($lastWidget) {
                        if ($lastWidget != $widget && $lastWidget.data('state')) {
                            $lastWidget.triggerHandler('click');
                        }
                    }

                    $lastWidget = $widget;
                } else {
                    $widget.next().collapse("hide");

                    if ($lastWidget == $widget)
                        $lastWidget = null;
                }

                // Set the button's state
                $widget.data('state', (isChecked) ? "on" : "off");
    
                // Set the button's icon
                $widget.find('.state-icon')
                    .removeClass()
                    .addClass('state-icon ' + settings[$widget.data('state')].icon);
    
                // Update the button's color
                if (isChecked) {
                    $widget.addClass(style + color + ' active');
                } else {
                    $widget.removeClass(style + color + ' active');
                }
            }
    
            // Initialization
            function init() {
                
                if ($widget.data('checked') == true) {
                    $checkbox.prop('checked', !$checkbox.is(':checked'));
                }
                
                updateDisplay();
    
                // Inject the icon if applicable
                if ($widget.find('.state-icon').length == 0) {
                    $widget.prepend('<span class="state-icon ' + settings[$widget.data('state')].icon + '"></span>');
                }
            }
            init();
        });
        
        $('.btn_compile').on('click', function(event) {
            event.preventDefault(); 
            
            if (!$lastWidget) {
                alert('请选择编译版本');
                return false;
            }

            var version = $lastWidget.data('version');
            var description = $lastWidget.data('description');
            $('#myModal #version').val(version);
            $('#myModal #description').text(description);

            $('#myModal').modal('show');
        });

        $('#myModal input[name="compilemode"]').on('click', function(event) {
            if($("#modeDev").is(":checked")){
                $('#divCompilePassword').hide();
            } else {
                //选择非开发版本，需要输入密码
                $('#compilePassword').val('');
                $('#divCompilePassword').show();
            }
        });    

        $('#btn_commit').on('click', function(event) {
            var dt = $.now();
            var password = "";
            var mode = $("input[name='compilemode']:checked").val();

            if(mode != "development"){
                var password = $('#compilePassword').val();

                if (password == '') {
                    alert('请输入发布版本编译密码');
                    return;
                }

            }

            $.getJSON('pre_compile.php', {'dt': dt, 'mode' : mode, 'password': password} ,function(resp) {
                if (resp.code != 0) {
                    alert(resp.message);
                    return;
                }

                $('#myModal form')[0].submit();
            });

        });
    });