<!DOCTYPE html>
<html lang="en">
    <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- The above 3 meta tags *must* come first in the head; any other head content must come *after* these tags -->
    <title>自动编译系统</title>

    <!-- Bootstrap -->
    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">

    <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
      <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
      <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
  </head>
  <body>
    <nav class="navbar navbar-inverse navbar-fixed-top">
      <div class="container">
        <div class="navbar-header">
          <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar" aria-expanded="false" aria-controls="navbar">
            <span class="sr-only">Toggle navigation</span>
            <span class="icon-bar"></span>
            <span class="icon-bar"></span>
            <span class="icon-bar"></span>
          </button>
          <a class="navbar-brand" href="#">自动编译系统</a>
        </div>
        <div id="navbar" class="collapse navbar-collapse">
          <ul class="nav navbar-nav">
            <li class="active"><a href="#">选择版本</a></li>
            <li><a href="compile_log.php">编译日志</a></li>
            <li><a href="compile_history.php">历史记录</a></li>
          </ul>
        </div><!--/.nav-collapse -->
      </div>
    </nav>

    <div class="container">

      <div class="starter-template">
        
            <div class="panel panel-default">
              <!-- Default panel contents -->
              <div class="panel-heading">请选择要编译的版本：</div>

              <div class="panel-body">
                    <div style="text-align:left;">
                    <ul id="check-list-box" class="list-group checked-list-box">
                      <?php
                        $directory = '/home/svn_release/release_build/customcfg';
                        $scan_result = array_diff(scandir($directory), array('..', '.'));

                        $summaryfile = '/home/svn_release/release_build/custom_summary';
                        $summary = file($summaryfile);

                        $array = array();
                        foreach($summary as $f){
                          $line = explode("=", $f);
                          $array[$line[0]] = $line[1];
                        }

                        foreach ( $scan_result as $key => $value ) {
                            $content = file_get_contents($directory.'/'.$value);
                            $desc = trim($array[$value]);
                        ?>
                        <li class="list-group-item" data-version="<?php echo $value?>" data-description="<?php echo $desc?>"><?php 
                        echo $value;

                        if ($desc && $desc != '')
                        {
                          ?>
                          <span class="label label-success"><?php echo $desc ?></span>
                          <?php
                        }
                        ?> 
                        </li>

                        <div class="collapse well" id="<?php echo $key ?>">
                          <div class="card card-block">
                              <?php echo nl2br(htmlspecialchars($content)) ?>
                          </div>
                          <br/>
                          <button type="button" class="btn btn-primary btn-sm btn_compile">开始编译</button>
                        </div>
                      <?php      
                        }
                      ?>
                    </ul>
                    </div>
              </div>

            </div>

      </div>

    </div><!-- /.container -->


    <!-- 模态框（Modal） -->
    <div class="modal fade" id="myModal" tabindex="-1" role="dialog" 
       aria-labelledby="myModalLabel" aria-hidden="true">
       <div class="modal-dialog">
          <div class="modal-content">
             <div class="modal-header">
                <button type="button" class="close" 
                   data-dismiss="modal" aria-hidden="true">
                      &times;
                </button>
                <h4 class="modal-title" id="myModalLabel">
                   开始编译
                </h4>
             </div>
             <div class="modal-body">
                <form class="form-horizontal" role="form" action="compile.php" method="post">
                  <div class="form-body">
                    <div class="form-group">
                  <label class="col-md-3 control-label">编译版本：</label>
                  <div class="col-md-8">
                      <input type="text" class="form-control" id="version" name="version" readonly>
                  </div>
                </div>

                <div class="form-body">
                    <div class="form-group">
                  <label class="col-md-3 control-label">编译参数：</label>
                  <div class="col-md-8">
                      <input type="text" class="form-control" id="parameter" name="parameter">
                  </div>
                </div>

                <div class="form-body">
                    <div class="form-group">
                  <label class="col-md-3 control-label">版本描述：</label>
                  <div class="col-md-8">
                    <span id="description" name="description" class="form-control-static"></span>
                  </div>
                </div>

                <div class="form-body">
                    <div class="form-group">
                  <label class="col-md-3 control-label">版本类型：</label>
                  <div class="col-md-8">
                    <input type="radio" checked id="modeDev" name="compilemode" value="development"> 开发版本
                    <input type="radio" id="modeTest" name="compilemode" value="test"> 测试版本
                    <input type="radio" id="modeProduct" name="compilemode" value="custom"> 发布版本
                  </div>
                </div>


                <div id="divCompilePassword" class="form-group" style="display: none">
                      <label class="col-md-3 control-label">编译密码：</label>
                      <div class="col-md-8">
                        <div class="input-icon right">
                          <i class="fa"></i> <input type="password" class="form-control"
                            placeholder="请输入编译密码" id="compilePassword" name="compilePassword">
                        </div>
                      </div>
                    </div>
                    </div>

                    <div class="form-group">
                      <label class="col-md-3 control-label">编译人：</label>
                      <div class="col-md-8">
                        <div class="input-icon right">
                          <i class="fa"></i> <input type="text" class="form-control"
                            placeholder="请输入您的姓名或邮箱" id="email" name="email">
                        </div>
                      </div>
                    </div>
                    </div>

                    <div class="form-group">
                      <label class="col-md-3 control-label">编译说明：</label>
                      <div class="col-md-8">
                        <div class="input-icon right">
                          <i class="fa"></i><textarea class="form-control" rows="3" id="remark" name="remark"></textarea>
                        </div>
                      </div>
                    </div>
                    </div>

                   </form> 
             </div>
             <div class="modal-footer">
                <button type="button" class="btn btn-default" 
                   data-dismiss="modal">取消
                </button>
                <button id="btn_commit" type="button" class="btn btn-primary">
                   提交
                </button>
             </div>
          </div><!-- /.modal-content -->
    </div><!-- /.modal -->


    <!-- jQuery (necessary for Bootstrap's JavaScript plugins) -->
    <script src="js/jquery.min.js"></script>
    <!-- Include all compiled plugins (below), or include individual files as needed -->
    <script src="js/bootstrap.min.js"></script>
    <script src="js/index.js"></script>
  </body>

</html>