<!DOCTYPE html>
<html lang="en">
    <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- The above 3 meta tags *must* come first in the head; any other head content must come *after* these tags -->
    <title>编译日志</title>

    <!-- Bootstrap -->
    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">

    <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
      <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
      <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
  </head>
  <body data-spy="scroll" data-target=".navbar" data-offset="50">
    <nav class="navbar navbar-inverse navbar-fixed-top">
      <div class="container">
        <div class="navbar-header">
          <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar" aria-expanded="false" aria-controls="navbar">
            <span class="sr-only">Toggle navigation</span>
            <span class="icon-bar"></span>
            <span class="icon-bar"></span>
            <span class="icon-bar"></span>
          </button>
          <a class="navbar-brand" href="#">自动编译系统</a>
        </div>
        <div id="navbar" class="collapse navbar-collapse">
          <ul class="nav navbar-nav">
            <li><a href="index.php">选择版本</a></li>
            <li class="active"><a href="#">编译日志</a></li>
            <li><a href="compile_history.php">历史记录</a></li>
          </ul>
        </div><!--/.nav-collapse -->
      </div>
    </nav>

    <div class="container">

      <div class="starter-template">
        
            <div class="panel panel-default">
              <?php
                $filename = "custom_back.txt";
                $file = fopen("custom_back.txt", "r");
                $line0 = fgets($file);
                $line1 = fgets($file);

                $array0 = explode(':',$line0);
                $array1 = explode(':',$line1);

                fclose($file);
              ?>

              <!-- Default panel contents -->
              <div class="panel-heading">

                    最近编译版本：
                    <?php 

                    echo $array0[1].'@'.$array1[1];
                    ?>
                    
                    <span id="statuscontainer">
                      
                    </span>
              </div>

              <div class="panel-body">
                    <div id="logcontainer" class="well" style="text-align:left;">正在加载日志信息，请稍候...</div>
              </div>

            </div>

      </div>

    </div><!-- /.container -->


    <!-- jQuery (necessary for Bootstrap's JavaScript plugins) -->
    <script src="js/jquery.min.js"></script>
    <!-- Include all compiled plugins (below), or include individual files as needed -->
    <script src="js/bootstrap.min.js"></script>

    <script type="text/javascript">
    $(function() {
        var audioElement = document.createElement('audio');
        audioElement.setAttribute('src', 'alert.mp3');

        var offset = 0;
        var logcontainer = $('#logcontainer');
        var statuscontainer = $('#statuscontainer');
        var laststatus = false;
        var refreshLog = function() {
            var dt = $.now();
            $.getJSON('compile_log_read.php?offset=' + offset, {'dt' : dt} ,function(resp) {
                if (offset == 0) {
                  logcontainer.html(resp.data);
                } else {
                  logcontainer.append(resp.data);
                }

                if (offset != resp.offset) {
                    offset = resp.offset;
                    $(window).scrollTop(logcontainer[0].scrollHeight);
                }

                if (resp.status == true) {
                  statuscontainer.html('<span class="label label-success">正在编译</span>');
                } else {
                  statuscontainer.html('<span class="label label-default">已结束</span>');
                }

                if (laststatus != resp.status) {
                    if (laststatus) {
                      audioElement.play();
                      alert('编译已结束，感谢使用！');
                    }

                    laststatus = resp.status;
                }

            });
        };

        t = setInterval(refreshLog, 3000); 
        refreshLog();
    });

    </script>
  </body>

</html>