<!DOCTYPE html>
<html lang="en">
    <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- The above 3 meta tags *must* come first in the head; any other head content must come *after* these tags -->
    <title>历史编译记录</title>

    <!-- Bootstrap -->
    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">

    <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
      <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
      <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
  </head>
  <body>
    <nav class="navbar navbar-inverse navbar-fixed-top">
      <div class="container">
        <div class="navbar-header">
          <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar" aria-expanded="false" aria-controls="navbar">
            <span class="sr-only">Toggle navigation</span>
            <span class="icon-bar"></span>
            <span class="icon-bar"></span>
            <span class="icon-bar"></span>
          </button>
          <a class="navbar-brand" href="#">自动编译系统</a>
        </div>
        <div id="navbar" class="collapse navbar-collapse">
          <ul class="nav navbar-nav">
            <li><a href="index.php">选择版本</a></li>
            <li><a href="compile_log.php">编译日志</a></li>
            <li class="active"><a href="#">历史记录</a></li>
          </ul>
        </div><!--/.nav-collapse -->
      </div>
    </nav>

    <?php
      $queryVersion = $_GET["version"];
      $maxCount = $_GET["maxCount"];
      if (empty($maxCount))
        $maxCount = 20;
    ?>

    <div class="container">

      <div class="starter-template">
        
            <div class="panel panel-default">

              <div class="panel-heading">
                      <form id="logQueryForm" class="form-inline" role="form" action="compile_history.php" method="get">
                        <div class="form-group">
                          <label for="version">编译版本：</label>
                          <input type="text" class="form-control" id="version" name="version" placeholder="编译版本" value= "<?php 
                            if (!empty($queryVersion))
                              echo $queryVersion
                           ?>" >
                        </div>
                        <div class="form-group">
                          <label for="displayCount">查询数量：</label>
                          <select id="maxCount" name="maxCount" class="form-control">
                             <option value="20">20条</option>
                             <option value="100">100条</option>
                             <option value="-1">全部记录</option>
                            </select>
                        </div>
                        <button id="btnLogQuery" type="submit" class="btn btn-default">查 询</button>
                      </form>
              </div>
              
              <div class="panel-body">
                    <table class="table table-striped table-hover" style="table-layout:fixed">
                      <thead>
                        <tr>
                          <th width="5%">#</th>
                          <th width="20%">编译版本</th>
                          <th width="10%">编译参数</th>
                          <th width="15%">编译时间</th>
                          <th width="15%">编译人</th>
                          <th>编译说明</th>
                        </tr>
                      </thead>

                      <tbody style="text-align:left">
                        <?php
                          $logfile = "compile.history";  

                          $file = file($logfile);
                          $file = array_reverse($file);
                          $count = 1;
                          foreach($file as $f){
                              $row = json_decode($f, true);

                              if (!empty($queryVersion) && $row["version"] != $queryVersion)
                                continue;

                              ?>
                              <tr>
                                    <td><?php echo $count ?></td>
                                    <td>
                                    <?php 
                                      echo $row["version"];

                                      $mode = $row["mode"];
                                      if ($mode === 0)
                                        $mode = 'development';
                                      else if ($mode === 1)
                                        $mode = 'custom';

                                      if ($mode == 'test')
                                        echo '<br/><span class="label label-info">测试版</span>';
                                      else if ($mode == 'custom')
                                        echo '<br/><span class="label label-success">发布版</span>';

                                    ?></td>
                                    <td style="word-break:break-all"><?php echo $row["parameter"] ?></td>
                                    <td><?php echo $row["starttime"] ?></td>
                                    <td><?php echo $row["email"] ?></td>
                                    <td style="word-break:break-all"><?php echo $row["remark"] ?></td>
                                  </tr>
                              <?php
                              $count++;
                              #最多显示maxCount条
                              if ($count > $maxCount && $maxCount > 0)
                                break;
                          }
                        ?>


                      </tbody>

                    </table>
              </div>

            </div>

      </div>

    </div><!-- /.container -->


    <!-- jQuery (necessary for Bootstrap's JavaScript plugins) -->
    <script src="js/jquery.min.js"></script>
    <!-- Include all compiled plugins (below), or include individual files as needed -->
    <script src="js/bootstrap.min.js"></script>

    <script type="text/javascript">
      $(document).ready(function(){  
        var selCount ="<?php echo $maxCount ?>"

        $('#maxCount').val(selCount);
      }); 

    </script>
  </body>

</html>